
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;

import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class CastleGraphics extends JFrame implements MouseListener, KeyListener{
	
	private final int HEIGHT = 600;
	private final int LENGTH = 960;
	public final int BUTTON_STARTX = 750;
	public final int BUTTON_ENDX = 900;
	public final int BUTTON_STARTY = 50;
	public final int BUTTON_ENDY = 100;
	private String typeSelected;
	private String[] shells;
	private int counter;
	private BufferedImage wall, wallBreached, wallHalf, wallQuarter, winnar;
	private AudioClip boom, hit;
	private Castle castle;
	private Cannon cannon;
	private String message;
	private boolean breached;
	private int totalCastleHealth;
	private boolean debugg;
	
	public CastleGraphics() {
		shells = new String[] {"Standard", "Bomb"};
		counter = 0;
		message = "use arrow keys to change angle and power and use spacebar to fire";
		breached = false;
		debugg = false;
		
		loadResources();
		updateType();
		newGame();
		
		this.setSize(LENGTH, HEIGHT);
		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		this.setTitle("Siege Game");
		this.setLocationRelativeTo(null);
		this.setResizable(false);
		this.setVisible(true);
		
		addMouseListener(this);
		addKeyListener(this);
	}
	
	private void updateType() {
		typeSelected = "Shell: " + shells[counter];
		counter++;
		if (counter > shells.length - 1) {
			counter =0;
		}
	}
	
	public void loadResources(){
		try {
				wall = ImageIO.read( getClass().getResource("/newCastle.png"));
				wallHalf = ImageIO.read( getClass().getResource("/wallHalf.png"));
				wallQuarter = ImageIO.read( getClass().getResource("/wallQuarter.png"));
				wallBreached = ImageIO.read( getClass().getResource("/wallBreached.png"));
				winnar = ImageIO.read( getClass().getResource("/winnar.png"));
		} catch (Exception e) {

		}

	}
	
	public void paint(Graphics g){
		if (castle.getHealth() <= 0){
			g.drawImage(wallBreached, 0,0, null);
			paintWin(g); 
		} else if (castle.getHealth() < (totalCastleHealth / 4)){
			g.drawImage(wallQuarter, 0,0, null);
			basicPaint(g);
		} else if (castle.getHealth() < (totalCastleHealth / 2)) {
			g.drawImage(wallHalf, 0,0, null);
			basicPaint(g);
		} else {
			g.drawImage(wall, 0, 0, null);
			basicPaint(g);
		}
	}
	
	public void basicPaint(Graphics g) {
		g.fillRect(BUTTON_STARTX, BUTTON_STARTY, 
				BUTTON_ENDX - BUTTON_STARTX, BUTTON_ENDY - BUTTON_STARTY);
		g.setColor(Color.BLACK);
		g.drawString(typeSelected, 410, 50);
		g.drawString("Angle: " + cannon.getAngle() + " Power: " + cannon.getPower() , 
				410, 75);
		if (debugg) {
			g.drawString("Castle Health: " + castle.getHealth(), 410, 90);
			g.drawString("Info " + cannon.getWorking() + " \\ " + castle.getDistance()
				+ " \\ " + castle.getDefenders(), 410, 110);
		}
		g.drawString(message, 20, 50);
		g.setColor(Color.WHITE);
		g.drawString("Change Shell", BUTTON_STARTX + ((BUTTON_ENDX - BUTTON_STARTX) / 3) - 10, 
				BUTTON_STARTY + ((BUTTON_ENDY - BUTTON_STARTY) / 2) + 3); 
	}
	
	public void paintWin(Graphics h) {
		h.setColor(Color.WHITE);
		h.setFont(new Font("Comic Sans", Font.BOLD, 69));
		h.drawString("a winner is you!! <3", 200, 300 );
	}
	
	public void newGame() {
		castle = new Castle();
		cannon = new Cannon();
		totalCastleHealth = castle.getHealth();
	}
	
	public void mouseClicked(MouseEvent e) {
		if ((e.getX() >= BUTTON_STARTX && e.getX() <= BUTTON_ENDX) && 
				(e.getY() >= BUTTON_STARTY && e.getY() <= BUTTON_ENDY)) {
			updateType();
			repaint();
		}
	}
	
	public boolean getHit() {
		int distance = cannon.getAngle() * cannon.getPower();
		if (distance - 5 > castle.getDistance() || distance + 5 < castle.getDistance()) {
			return false;
		}
		return true;
	}
	public void fire() {
		if (!getHit()) {
			message = "Missed";
		}
		if (cannon.getWorking() && getHit()) {
			if (counter == 1) {
				castle.hit(cannon, new StandardShot());
				message = "Hit for " + castle.getLastHit();
			}
			if (counter == 0) {
				castle.hit(cannon, new Bomb());
				message = "Hit for " + castle.getLastHit();
			}
		}
		if (counter == 0) {
			cannon.explode();
		}
		if (castle.getHealth() <= 0) {
			breached = true;
		}
	}
	
	public void mouseEntered(MouseEvent e) {
		
	}

	
	public void mouseExited(MouseEvent e) {
		
	}

	
	public void mousePressed(MouseEvent e) {
		
	}

	
	public void mouseReleased(MouseEvent e) {
		
	}

	public void keyPressed(KeyEvent e) {
		int key = e.getKeyCode();
		if (key == 38) {
			cannon.setAngle(cannon.getAngle() + 1);
			if (cannon.getAngle() > 10) {
				cannon.setAngle(0);
			}
		}
		if (key == 40) {
			cannon.setAngle(cannon.getAngle() - 1);
			if (cannon.getAngle() < 0) {
				cannon.setAngle(10);
			}
		}
		if (key == 37) {
			cannon.setPower(cannon.getPower() - 1);
			if (cannon.getPower() < 0) {
				cannon.setPower(10);
			}
		}
		if (key == 39) {
			cannon.setPower(cannon.getPower() + 1);
			if (cannon.getPower() > 10) {
				cannon.setPower(0);
			}
		}
		if (key == 32) {
			fire();
		}
		if (key == 192) {
			debugg = true;
		}
		repaint();
	}

	public void keyReleased(KeyEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void keyTyped(KeyEvent arg0) {
		// TODO Auto-generated method stub
		
	}

}